using DifferentialEquations, Distributions, Plots, XLSX, DataFrames, MAT

#S->0
β = 0.95
σ = 0.14
γ = 0.05

#I->0
β = 0.5
σ = 0.14
γ = 0.9

#Normal
β = 0.5
σ = 0.14
γ = 0.05

normal = Normal(50, 20)
multiplier = β / pdf(normal, 50)

function Q(t)
    pdf.(normal, t) .* multiplier
end

#actual_Q = []
#time_stamp = []

function SEIR!(du, u, p, t)
    s, e, i, r = u
    n = s + e + i + r
    β = p[1]
    σ = p[2]
    γ = p[3]
    du[1] = ds = -(β - Q(t)) * s * i / n
    du[2] = de = (β - Q(t)) * s * i / n - σ * e
    du[3] = di = σ * e - γ * i
    du[4] = dr = γ * i
    #global actual_Q = push!(actual_Q, Q(t))
    #global time_stamp = push!(time_stamp, t)
    #println(Q(t))
    return [du[1], du[2], du[3], du[4]]
end

u0 = [100000.0, 1000.0, 50.0, 10.0]
N = sum(u0)
p = [β, σ, γ]
ts = 0.0
tend = 100.0
tspan = (ts, tend)
prob = ODEProblem(SEIR!, u0, tspan, p)
res = Array(solve(prob, AutoTsit5(Rosenbrock23()), u0=u0, p=p, saveat = ts:1:tend))

#plot!(res[1, 1:end-1], label="susceptible(β = 0.8)")

infected = res[3, :]
plot(infected, label="infected(β = 0.8)")
plot!(xlabel="days", ylabel="population")
recovered = res[4, :]
plot!(recovered, label="recovered")


########TV########
d = Normal(0, 5)
noise_i = rand(d, size(infected)[1])
noise_r = rand(d, size(recovered)[1])

infected = infected + noise_i
recovered = recovered + noise_r

plot!(infected, label="infected with noise")
plot!(recovered, label="recovreed with noise")
df_res = DataFrames.DataFrame(hcat(infected, recovered))
cd("/Users/urielyang/OneDrive - Emory University/Honors")
XLSX.writetable("states.xlsx", REPORT_A=( collect(DataFrames.eachcol(df_res)), DataFrames.names(df_res) ))
file = matopen("/Users/urielyang/OneDrive - Emory University/Summer 2020/Honors/derivative_TV.mat")
derivative = read(file, "dx")
dI = derivative[3:end, 1]
dR = derivative[3:end, 2]
################
dI = diff(infected)
dR = diff(recovered)

DX = similar(res)
cur_time = 0.0
for (i, xi) in enumerate(eachcol(res))
    DX[:,i] = SEIR!(zeros(4, 1), xi, p, cur_time)
    global cur_time = cur_time + 1
end

plot(DX[3, 2:end], label ="real dI")
plot!(dI, label ="dI with noise")
plot!(DX[4, 2:end], label ="real dR")
plot!(dR, label ="dR with noise")

#γ_real = DX[4, 2:end] ./ infected[2:end]
#γ_recovered = dR ./ infected[2:end]
#plot(γ_real)
#plot!(γ_recovered)

exposed = (dI + dR) / σ
plot(exposed, label="recovered exposed")
plot!(res[2,2:end], label="actual exposed")
dE = diff(exposed)
plot(dE, label="recovered dE")
plot!(DX[2, 2:end], label="actual dE")


dS = - (dE .+ σ * exposed[2:end])
plot(dS, label="recovered dS")
plot!(DX[1, 2:end], label="actual dS")

S = zeros(size(dS)[1]+1, 1)
S[1] = u0[1]
for i in 2:size(S)[1]
    S[i] = S[i-1] + dS[i-1]
end
plot(S, label="recovered susceptible", ylims=(0, 10000))
plot!(res[1, 1:end-1], label="actual susceptible")

#M = dE + σ * exposed[2:end]
#df_res = DataFrames.DataFrame(hcat(infected[3:end], S[2:end], M))
#df_res = DataFrames.DataFrame(hcat(infected[15:80], recovered[15:80]))
df_res = DataFrames.DataFrame(hcat(infected, recovered))
cd("/Users/urielyang/OneDrive - Emory University/Honors")
XLSX.writetable("states3.xlsx", REPORT_A=(collect(DataFrames.eachcol(df_res)), DataFrames.names(df_res)))

t = 15.0:1:80.0

combined_q = (dE + σ * exposed[2:end]) * N ./ (infected[3:end] .* S[2:end])
quarantine = β .- combined_q
plot(t, quarantine[15:80])


val = Q(t)
plot(diff(val))
plot!(t, val, label="actual Q")

############Test#######
temp = β .- (DX[2, :] + σ * res[2,:]) * N ./ (res[3, :] .* res[1, :])
plot(temp)

temp1 = (DX[2, :] + σ * res[2,:])[3:end]
temp1_1 = dE + σ * exposed[2:end]
plot(temp1)
plot!(temp1_1)

temp2 = (res[3, :] .* res[1, :])[3:end]
temp2_1 = infected[3:end] .* S[2:end]
plot(temp2)
plot!(temp2_1)


temp3 = β .- temp1 ./ temp2 * N
temp3_1 = β .- temp1_1 ./ temp2_1*N
plot(temp3, label = "actual Q")
plot!(temp3_1, label = "recovered Q")
#plot!(time_stamp, actual_Q)

plot(β.+dS * N./infected[2:end-1]./S[2:end], label="recovered Q")
plot!(β.+DX[1, 3:end]*N./infected[3:end]./res[1, 2:end-1], label="actual Q")
Q_recovered = β.+dS * N./infected[2:end-1]./S[2:end]
cd("/Users/urielyang/OneDrive - Emory University/Honors")
XLSX.openxlsx("Artificial_Q.xlsx", mode="w") do xf
    sheet = xf[1]
    XLSX.rename!(sheet, "Data")
    sheet["A1", dim=1] = collect(Q_recovered)
    sheet["B1", dim=1] = collect(val)
end
